/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.items;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2286;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2457;
import net.minecraft.class_2462;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2599;
import net.minecraft.class_2680;
import net.minecraft.class_2747;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import wile.redstonepen.ModContent;
import wile.redstonepen.blocks.RedstoneTrack;
import wile.redstonepen.libmc.Auxiliaries;
import wile.redstonepen.libmc.Inventories;
import wile.redstonepen.libmc.Overlay;
import wile.redstonepen.libmc.RsSignals;
import wile.redstonepen.libmc.StandardItems;

public class RedstonePenItem
extends StandardItems.BaseItem {
    public RedstonePenItem(class_1792.class_1793 properties) {
        super(properties);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, class_1792.class_9635 ctx, List<class_2561> tooltip, class_1836 flag) {
        if (stack.method_7936() > 0) {
            tooltip.add((class_2561)Auxiliaries.localizable("item.redstonepen.pen.tooltip.numstored", stack.method_7936() - stack.method_7919()));
        } else {
            tooltip.add((class_2561)Auxiliaries.localizable("item.redstonepen.pen.tooltip.rsfrominventory"));
        }
        Auxiliaries.Tooltip.addInformation(stack, ctx, tooltip, flag, true);
    }

    public int method_7837() {
        return 0;
    }

    public boolean method_7878(class_1799 toRepair, class_1799 repair) {
        return false;
    }

    public boolean method_31567(class_1799 stack) {
        return stack.method_7963() && stack.method_7919() > 0;
    }

    public int method_31569(class_1799 stack) {
        return stack.method_7936() <= 0 ? 13 : 13 - class_3532.method_15340((int)Math.round(13.0f * (float)stack.method_7919() / (float)stack.method_7936()), (int)0, (int)13);
    }

    public int method_31571(class_1799 stack) {
        return 0x663333;
    }

    @Override
    public boolean doesSneakBypassUse(class_1799 stack, class_4538 world, class_2338 pos, class_1657 player) {
        return true;
    }

    public float method_58404(class_1799 stack, class_2680 state) {
        return state.method_26204().method_36555() < 0.5f ? 10000.0f : 0.0f;
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        class_1799 stack = player.method_5998(player.method_6058());
        if (!RedstonePenItem.isPen(stack)) {
            stack = player.method_6047();
        }
        if (!RedstonePenItem.isPen(stack)) {
            stack = player.method_6079();
        }
        if (RedstonePenItem.isPen(stack)) {
            this.attack(stack, pos, player);
        }
        return false;
    }

    @Override
    public boolean onBlockStartBreak(class_1799 stack, class_2338 pos, class_1657 player) {
        this.attack(stack, pos, player);
        return false;
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        class_3965 rtr;
        class_1657 player = context.method_8036();
        class_1268 hand = context.method_20287();
        class_2338 pos = context.method_8037();
        class_2350 facing = context.method_8038();
        class_1937 world = context.method_8045();
        class_2680 state = world.method_8320(pos);
        class_1799 stack = context.method_8041();
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof RedstoneTrack.RedstoneTrackBlock) {
            RedstoneTrack.RedstoneTrackBlock track = (RedstoneTrack.RedstoneTrackBlock)class_22482;
            if (world.method_8608()) {
                return class_1269.field_5812;
            }
            class_3965 rtr2 = new class_3965(context.method_17698(), context.method_8038(), context.method_8037(), context.method_17699());
            return track.modifySegments(state, world, pos, player, stack, hand, rtr2, false, true);
        }
        if (!RedstoneTrack.RedstoneTrackBlock.canBePlacedOnFace(state, world, pos, facing)) {
            return class_1269.field_5814;
        }
        if (world.method_8608()) {
            return class_1269.field_5812;
        }
        class_2338 target_pos = pos.method_10093(facing);
        class_2680 target_state = world.method_8320(target_pos);
        class_2248 class_22483 = target_state.method_26204();
        if (class_22483 instanceof RedstoneTrack.RedstoneTrackBlock) {
            RedstoneTrack.RedstoneTrackBlock track_block = (RedstoneTrack.RedstoneTrackBlock)class_22483;
            rtr = new class_3965(context.method_17698(), context.method_8038(), target_pos, context.method_17699());
            return track_block.modifySegments(target_state, world, target_pos, player, stack, hand, rtr, false, true);
        }
        rtr = new class_3965(context.method_17698(), context.method_8038(), target_pos, context.method_17699());
        class_1750 ctx = new class_1750(player, context.method_20287(), new class_1799((class_1935)class_1802.field_8725), rtr);
        class_2680 rs_state = ModContent.references.TRACK_BLOCK.method_9605(ctx);
        if (rs_state == null) {
            return class_1269.field_5814;
        }
        if (!target_state.method_26166(ctx)) {
            return class_1269.field_5814;
        }
        if (!world.method_8652(target_pos, rs_state, 19)) {
            return class_1269.field_5814;
        }
        class_2680 placed_state = world.method_8320(target_pos);
        class_2248 class_22484 = placed_state.method_26204();
        if (class_22484 instanceof RedstoneTrack.RedstoneTrackBlock) {
            RedstoneTrack.RedstoneTrackBlock track_block = (RedstoneTrack.RedstoneTrackBlock)class_22484;
            return track_block.modifySegments(target_state, world, target_pos, player, stack, hand, rtr, false, true) == class_1269.field_5814 ? class_1269.field_5814 : class_1269.field_21466;
        }
        world.method_8650(target_pos, false);
        return class_1269.field_5814;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int itemSlot, boolean isSelected) {
        if (!isSelected || !entity.method_5715() || world.method_8608() || (world.method_8510() & 1L) != 0L || !(entity instanceof class_3222)) {
            return;
        }
        class_239 rt = entity.method_5745(10.0, 0.0f, false);
        if (rt.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        class_3965 brtr = (class_3965)rt;
        class_2338 pos = brtr.method_17777();
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        class_2350 rs_side = brtr.method_17780().method_10153();
        class_5250 tc = class_2561.method_43473();
        if (block == class_2246.field_10091) {
            tc = Auxiliaries.localizable("overlay.wire_power", this.powerFormatted((Integer)state.method_11654((class_2769)class_2457.field_11432)));
        } else if (block == ModContent.references.TRACK_BLOCK) {
            RedstoneTrack.TrackBlockEntity te = RedstoneTrack.RedstoneTrackBlock.tile((class_1922)world, pos).orElse(null);
            if (te == null) {
                return;
            }
            tc = Auxiliaries.localizable("overlay.track_power", this.powerFormatted(te.getSidePower(rs_side)));
            if (Auxiliaries.isDevelopmentMode()) {
                tc.method_10852((class_2561)class_2561.method_43470((String)String.format(" | flags: %016x, p: ", te.getStateFlags())));
                tc.method_10852((class_2561)class_2561.method_43470((String)Arrays.stream(class_2350.values()).map(side -> side.toString().substring(0, 1) + te.getRedstonePower(side.method_10153(), false)).collect(Collectors.joining(","))));
            }
        } else if (state.method_27852(class_2246.field_10450)) {
            tc = Auxiliaries.localizable("overlay.direct_power", this.powerFormatted((Boolean)state.method_11654((class_2769)class_2462.field_10911) != false ? 15 : 0));
            tc.method_10852((class_2561)Auxiliaries.localizable("overlay.repeater_delay", state.method_11654((class_2769)class_2462.field_11451)));
        } else if (state.method_27852(class_2246.field_10377)) {
            class_2586 te = world.method_8321(pos);
            if (te instanceof class_2599) {
                tc = Auxiliaries.localizable("overlay.direct_power", this.powerFormatted(((class_2599)te).method_11071()));
                switch ((class_2747)state.method_11654((class_2769)class_2286.field_10789)) {
                    case field_12576: {
                        tc.method_10852((class_2561)Auxiliaries.localizable("overlay.comparator_compare"));
                        break;
                    }
                    case field_12578: {
                        tc.method_10852((class_2561)Auxiliaries.localizable("overlay.comparator_subtract"));
                        break;
                    }
                }
            }
        } else if (state.method_26219()) {
            int p = Math.max(state.method_26203((class_1922)world, pos, rs_side), state.method_26195((class_1922)world, pos, rs_side));
            if (p > 0) {
                tc = Auxiliaries.localizable("overlay.direct_power", this.powerFormatted(p));
            } else {
                class_2350 max_side = null;
                for (class_2350 side2 : class_2350.values()) {
                    int ps;
                    if (side2 == rs_side || (ps = Math.max(state.method_26203((class_1922)world, pos, side2), state.method_26195((class_1922)world, pos, side2))) <= p) continue;
                    p = ps;
                    max_side = side2;
                    if (p >= 15) break;
                }
                tc = p == 0 || max_side == null ? Auxiliaries.localizable("overlay.direct_power", this.powerFormatted(p)) : Auxiliaries.localizable("overlay.direct_power_at", this.powerFormatted(p), max_side.method_10153().toString());
            }
        } else if (RsSignals.canEmitWeakPower(state, world, pos, rs_side)) {
            class_2350 max_side = class_2350.values()[0];
            int p = 0;
            for (class_2350 d : class_2350.values()) {
                int ps = world.method_49808(pos.method_10093(d), d);
                if (ps <= p) continue;
                p = ps;
                max_side = d;
                if (p >= 15) break;
            }
            if (p > 0) {
                tc = Auxiliaries.localizable("overlay.indirect_power", this.powerFormatted(p), max_side.toString());
            }
        }
        if (Auxiliaries.isDevelopmentMode()) {
            String look_dir = class_2350.method_10159((class_1297)entity)[0].toString().substring(0, 1);
            tc.method_10852((class_2561)class_2561.method_43470((String)String.format(" | %s [%d,%d,%d]", look_dir, pos.method_10263(), pos.method_10264(), pos.method_10260())));
        }
        Overlay.show((class_3222)entity, (class_2561)tc, 400);
    }

    private boolean attack(class_1799 stack, class_2338 pos, class_1657 player) {
        class_1937 world = player.method_5770();
        class_2680 state = world.method_8320(pos);
        if (state.method_27852((class_2248)ModContent.references.TRACK_BLOCK)) {
            class_239 rt = player.method_5745(10.0, 0.0f, false);
            if (rt.method_17783() != class_239.class_240.field_1332) {
                return false;
            }
            class_1268 hand = player.method_5998(class_1268.field_5808).method_7909() == this ? class_1268.field_5808 : class_1268.field_5810;
            class_2248 class_22482 = state.method_26204();
            if (!(class_22482 instanceof RedstoneTrack.RedstoneTrackBlock)) {
                return false;
            }
            RedstoneTrack.RedstoneTrackBlock track = (RedstoneTrack.RedstoneTrackBlock)class_22482;
            track.modifySegments(state, player.method_5770(), pos, player, stack, hand, (class_3965)rt, true, false);
            return true;
        }
        if (state.method_27852(class_2246.field_10091)) {
            RedstonePenItem.pushRedstone(stack, 1, player);
            world.method_8650(pos, false);
            return true;
        }
        return false;
    }

    public static void pushRedstone(class_1799 stack, int amount, class_1657 player) {
        if (player.method_7337()) {
            return;
        }
        if (amount <= 0) {
            return;
        }
        if (RedstonePenItem.isPen(stack)) {
            if (stack.method_7936() <= 0) {
                class_1799 remaining = Inventories.insert(player, new class_1799((class_1935)class_1802.field_8725, amount), false);
                if (!remaining.method_7960()) {
                    Inventories.give(player, remaining);
                }
            } else if (stack.method_7919() >= amount) {
                stack.method_7974(stack.method_7919() - amount);
            } else {
                stack.method_7974(0);
                Inventories.give(player, new class_1799((class_1935)class_1802.field_8725, amount -= stack.method_7919()));
            }
        } else if (stack.method_7909() == class_1802.field_8725) {
            if (stack.method_7947() <= stack.method_7914() - amount) {
                stack.method_7933(amount);
            } else {
                Inventories.give(player, new class_1799((class_1935)class_1802.field_8725, amount));
            }
        } else {
            Inventories.give(player, new class_1799((class_1935)class_1802.field_8725, amount));
        }
    }

    public static int popRedstone(class_1799 stack, int amount, class_1657 player, class_1268 hand) {
        if (player.method_7337()) {
            return amount;
        }
        if (amount <= 0) {
            return 0;
        }
        if (RedstonePenItem.isPen(stack)) {
            if (stack.method_7936() > 0) {
                int dmg = stack.method_7919() + amount;
                if (dmg >= stack.method_7936()) {
                    amount = stack.method_7936() - stack.method_7919();
                    player.method_6122(hand, class_1799.field_8037);
                } else {
                    stack.method_7974(dmg);
                }
            } else {
                amount = Inventories.extract(player, new class_1799((class_1935)class_1802.field_8725), amount, false).method_7947();
            }
        } else if (stack.method_7909() == class_1802.field_8725) {
            if (stack.method_7947() <= amount) {
                amount = stack.method_7947();
                player.method_6122(hand, class_1799.field_8037);
            } else {
                stack.method_7934(amount);
            }
        }
        return amount;
    }

    public static boolean hasEnoughRedstone(class_1799 stack, int amount, class_1657 player) {
        if (player.method_7337()) {
            return true;
        }
        if (RedstonePenItem.isPen(stack)) {
            if (stack.method_7936() > 0) {
                return stack.method_7919() < stack.method_7936() - amount;
            }
            return Inventories.extract(player, new class_1799((class_1935)class_1802.field_8725), amount, true).method_7947() >= amount;
        }
        if (stack.method_7909() == class_1802.field_8725) {
            return stack.method_7947() >= amount;
        }
        return false;
    }

    public static boolean isFullRedstone(class_1799 stack) {
        if (RedstonePenItem.isPen(stack)) {
            return stack.method_7919() <= 0;
        }
        if (stack.method_7909() == class_1802.field_8725) {
            return stack.method_7947() >= stack.method_7914();
        }
        return false;
    }

    public static boolean isPen(class_1799 stack) {
        return stack.method_7909() instanceof RedstonePenItem;
    }

    private String powerFormatted(int p) {
        return String.format("%02d", p);
    }
}

